/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.init;

import com.nyfaria.numismaticoverhaul.block.PiggyBankBlock;
import com.nyfaria.numismaticoverhaul.block.PiggyBankBlockEntity;
import com.nyfaria.numismaticoverhaul.block.ShopBlock;
import com.nyfaria.numismaticoverhaul.block.ShopBlockEntity;
import com.nyfaria.numismaticoverhaul.init.ItemInit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"numismaticoverhaul");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"numismaticoverhaul");
    public static final RegistryObject<Block> PIGGY_BANK = BlockInit.registerBlock("piggy_bank", PiggyBankBlock::new);
    public static final RegistryObject<Block> SHOP = BlockInit.registerBlock("shop", () -> new ShopBlock(false));
    public static final RegistryObject<Block> INEXHAUSTIBLE_SHOP = BlockInit.registerBlock("inexhaustible_shop", () -> new ShopBlock(true));
    public static final RegistryObject<BlockEntityType<PiggyBankBlockEntity>> PIGGY_BANK_BE = BLOCK_ENTITIES.register("piggy_bank", () -> BlockEntityType.Builder.m_155273_(PiggyBankBlockEntity::new, (Block[])new Block[]{(Block)PIGGY_BANK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<ShopBlockEntity>> SHOP_BE = BLOCK_ENTITIES.register("shop", () -> BlockEntityType.Builder.m_155273_(ShopBlockEntity::new, (Block[])new Block[]{(Block)SHOP.get(), (Block)INEXHAUSTIBLE_SHOP.get()}).m_58966_(null));

    protected static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return BlockInit.registerBlock(name, block, b -> () -> new BlockItem((Block)b.get(), ItemInit.getItemProperties()));
    }

    protected static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, Function<RegistryObject<T>, Supplier<? extends BlockItem>> item) {
        RegistryObject reg = BLOCKS.register(name, block);
        ItemInit.ITEMS.register(name, () -> (BlockItem)((Supplier)item.apply(reg)).get());
        return reg;
    }
}

